<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('name', 'description', 'tags', 'dimension', 'weight', 'price', 'stock', 'condition', 'publied', 'reference', 'slug', 'store_id', 'image_id');
    protected $visible = array('name', 'description', 'tags', 'dimension', 'weight', 'price', 'stock', 'condition', 'publied', 'reference', 'slug', 'store_id', 'image_id');

    public function stores()
    {
        return $this->belongsTo('App\Models\Store');
    }

    public function images()
    {
        return $this->belongsTo('App\Models\Image');
    }

    public function commands()
    {
        return $this->belongsToMany('App\Models\Role');
    }

    public function promotions()
    {
        return $this->belongsToMany('App\Models\Promotion');
    }

    public function taxes()
    {
        return $this->belongsToMany('App\Models\Tax');
    }

}